{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetUseGeometry: Boolean;
    procedure SetUseGeometry(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCollidables: TMFNode;
    { Internal wrapper for property @code(Collidables). This wrapper API may change, we advise to access simpler @code(Collidables) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCollidables: TMFNode read FFdCollidables;
    {  }
    procedure SetCollidables(const Value: array of TX3DNode);

    strict private FFdUseGeometry: TSFBool;
    { Internal wrapper for property @code(UseGeometry). This wrapper API may change, we advise to access simpler @code(UseGeometry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUseGeometry: TSFBool read FFdUseGeometry;
    {  }
    property UseGeometry: Boolean read GetUseGeometry write SetUseGeometry;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionSpaceNode ----------------------------------------------- }

procedure TCollisionSpaceNode.SetCollidables(const Value: array of TX3DNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TX3DNode));
  FdCollidables.Send(A);
end;

function TCollisionSpaceNode.GetUseGeometry: Boolean;
begin
  Result := FdUseGeometry.Value;
end;

procedure TCollisionSpaceNode.SetUseGeometry(const Value: Boolean);
begin
  FdUseGeometry.Send(Value);
end;

class function TCollisionSpaceNode.ClassX3DType: String;
begin
  Result := 'CollisionSpace';
end;

procedure TCollisionSpaceNode.CreateNode;
begin
  inherited;

  FFdCollidables := TMFNode.Create(Self, True, 'collidables', [TAbstractNBodyCollisionSpaceNode, TAbstractNBodyCollidableNode]);
   FdCollidables.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCollidables);

  FFdUseGeometry := TSFBool.Create(Self, True, 'useGeometry', false);
   FdUseGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUseGeometry);

  DefaultContainerField := 'children';
end;

{$endif read_implementation}
