{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_index: TMFInt32Event;
    {  }
    public property EventSet_index: TMFInt32Event read FEventSet_index;

    strict private FFdIndex: TMFInt32;
    { Internal wrapper for property @code(Index). This wrapper API may change, we advise to access simpler @code(Index) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdIndex: TMFInt32 read FFdIndex;
    {  }
    procedure SetIndex(const Value: array of Int32); overload;
    {  }
    procedure SetIndex(const Value: TInt32List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedTriangleSetNode ----------------------------------------------- }

procedure TIndexedTriangleSetNode.SetIndex(const Value: array of Int32);
begin
  FdIndex.Send(Value);
end;

procedure TIndexedTriangleSetNode.SetIndex(const Value: TInt32List);
begin
  FdIndex.Send(Value);
end;

class function TIndexedTriangleSetNode.ClassX3DType: String;
begin
  Result := 'IndexedTriangleSet';
end;

procedure TIndexedTriangleSetNode.CreateNode;
begin
  inherited;

  FEventSet_index := TMFInt32Event.Create(Self, 'set_index', true);
  AddEvent(FEventSet_index);

  FFdIndex := TMFInt32.Create(Self, False, 'index', []);
   FdIndex.ChangeAlways := chGeometry;
  AddField(FFdIndex);
end;

{$endif read_implementation}
