{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetApplied: Boolean;
    procedure SetApplied(const Value: Boolean);
    function GetLinewidthScaleFactor: Single;
    procedure SetLinewidthScaleFactor(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdApplied: TSFBool;
    { Internal wrapper for property @code(Applied). This wrapper API may change, we advise to access simpler @code(Applied) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdApplied: TSFBool read FFdApplied;
    {  }
    property Applied: Boolean read GetApplied write SetApplied;

    strict private FFdLinetype: TSFInt32;
    { Internal wrapper for property @code(Linetype). This wrapper API may change, we advise to access simpler @code(Linetype) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLinetype: TSFInt32 read FFdLinetype;

    strict private FFdLinewidthScaleFactor: TSFFloat;
    { Internal wrapper for property @code(LinewidthScaleFactor). This wrapper API may change, we advise to access simpler @code(LinewidthScaleFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLinewidthScaleFactor: TSFFloat read FFdLinewidthScaleFactor;
    {  }
    property LinewidthScaleFactor: Single read GetLinewidthScaleFactor write SetLinewidthScaleFactor;

{$endif read_interface}

{$ifdef read_implementation}

{ TLinePropertiesNode ----------------------------------------------- }

function TLinePropertiesNode.GetApplied: Boolean;
begin
  Result := FdApplied.Value;
end;

procedure TLinePropertiesNode.SetApplied(const Value: Boolean);
begin
  FdApplied.Send(Value);
end;

function TLinePropertiesNode.GetLinewidthScaleFactor: Single;
begin
  Result := FdLinewidthScaleFactor.Value;
end;

procedure TLinePropertiesNode.SetLinewidthScaleFactor(const Value: Single);
begin
  FdLinewidthScaleFactor.Send(Value);
end;

class function TLinePropertiesNode.ClassX3DType: String;
begin
  Result := 'LineProperties';
end;

procedure TLinePropertiesNode.CreateNode;
begin
  inherited;

  FFdApplied := TSFBool.Create(Self, True, 'applied', true);
   FdApplied.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdApplied);

  FFdLinetype := TSFInt32.Create(Self, True, 'linetype', 1);
   FdLinetype.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinetype);

  FFdLinewidthScaleFactor := TSFFloat.Create(Self, True, 'linewidthScaleFactor', 0);
   FdLinewidthScaleFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinewidthScaleFactor);

  DefaultContainerField := 'lineProperties';
end;

{$endif read_implementation}
