{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetTessellationScale: Single;
    procedure SetTessellationScale(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventAddGeometry: TMFNodeEvent;
    {  }
    public property EventAddGeometry: TMFNodeEvent read FEventAddGeometry;

    strict private FEventRemoveGeometry: TMFNodeEvent;
    {  }
    public property EventRemoveGeometry: TMFNodeEvent read FEventRemoveGeometry;

    strict private FFdGeometry: TMFNode;
    { Internal wrapper for property @code(Geometry). This wrapper API may change, we advise to access simpler @code(Geometry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeometry: TMFNode read FFdGeometry;
    {  }
    procedure SetGeometry(const Value: array of TAbstractNurbsSurfaceGeometryNode);

    strict private FFdTessellationScale: TSFFloat;
    { Internal wrapper for property @code(TessellationScale). This wrapper API may change, we advise to access simpler @code(TessellationScale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTessellationScale: TSFFloat read FFdTessellationScale;
    {  }
    property TessellationScale: Single read GetTessellationScale write SetTessellationScale;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @code(BboxCenter). This wrapper API may change, we advise to access simpler @code(BboxCenter) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @code(BboxSize). This wrapper API may change, we advise to access simpler @code(BboxSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSetNode ----------------------------------------------- }

procedure TNurbsSetNode.SetGeometry(const Value: array of TAbstractNurbsSurfaceGeometryNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractNurbsSurfaceGeometryNode));
  FdGeometry.Send(A);
end;

function TNurbsSetNode.GetTessellationScale: Single;
begin
  Result := FdTessellationScale.Value;
end;

procedure TNurbsSetNode.SetTessellationScale(const Value: Single);
begin
  FdTessellationScale.Send(Value);
end;

function TNurbsSetNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TNurbsSetNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function TNurbsSetNode.ClassX3DType: String;
begin
  Result := 'NurbsSet';
end;

procedure TNurbsSetNode.CreateNode;
begin
  inherited;

  FEventAddGeometry := TMFNodeEvent.Create(Self, 'addGeometry', true);
  AddEvent(FEventAddGeometry);

  FEventRemoveGeometry := TMFNodeEvent.Create(Self, 'removeGeometry', true);
  AddEvent(FEventRemoveGeometry);

  FFdGeometry := TMFNode.Create(Self, True, 'geometry', [TAbstractNurbsSurfaceGeometryNode]);
   FdGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeometry);

  FFdTessellationScale := TSFFloat.Create(Self, True, 'tessellationScale', 1.0);
   FdTessellationScale.ChangeAlways := chVisibleNonGeometry;
   FdTessellationScale.MustBeNonnegative := true;
  AddField(FFdTessellationScale);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
