{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetInitialDestination: TVector3;
    procedure SetInitialDestination(const Value: TVector3);
    function GetInitialValue: TVector3;
    procedure SetInitialValue(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_destination: TSFVec3fEvent;
    {  }
    public property EventSet_destination: TSFVec3fEvent read FEventSet_destination;

    strict private FEventSet_value: TSFVec3fEvent;
    {  }
    public property EventSet_value: TSFVec3fEvent read FEventSet_value;

    strict private FEventValue_changed: TSFVec3fEvent;
    {  }
    public property EventValue_changed: TSFVec3fEvent read FEventValue_changed;

    strict private FFdInitialDestination: TSFVec3f;
    { Internal wrapper for property @code(InitialDestination). This wrapper API may change, we advise to access simpler @code(InitialDestination) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialDestination: TSFVec3f read FFdInitialDestination;
    {  }
    property InitialDestination: TVector3 read GetInitialDestination write SetInitialDestination;

    strict private FFdInitialValue: TSFVec3f;
    { Internal wrapper for property @code(InitialValue). This wrapper API may change, we advise to access simpler @code(InitialValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialValue: TSFVec3f read FFdInitialValue;
    {  }
    property InitialValue: TVector3 read GetInitialValue write SetInitialValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TPositionChaserNode ----------------------------------------------- }

function TPositionChaserNode.GetInitialDestination: TVector3;
begin
  Result := FdInitialDestination.Value;
end;

procedure TPositionChaserNode.SetInitialDestination(const Value: TVector3);
begin
  FdInitialDestination.Send(Value);
end;

function TPositionChaserNode.GetInitialValue: TVector3;
begin
  Result := FdInitialValue.Value;
end;

procedure TPositionChaserNode.SetInitialValue(const Value: TVector3);
begin
  FdInitialValue.Send(Value);
end;

class function TPositionChaserNode.ClassX3DType: String;
begin
  Result := 'PositionChaser';
end;

procedure TPositionChaserNode.CreateNode;
begin
  inherited;

  FEventSet_destination := TSFVec3fEvent.Create(Self, 'set_destination', true);
  AddEvent(FEventSet_destination);

  FEventSet_value := TSFVec3fEvent.Create(Self, 'set_value', true);
  AddEvent(FEventSet_value);

  FEventValue_changed := TSFVec3fEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdInitialDestination := TSFVec3f.Create(Self, False, 'initialDestination', Vector3(0, 0, 0));
   FdInitialDestination.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialDestination);

  FFdInitialValue := TSFVec3f.Create(Self, False, 'initialValue', Vector3(0, 0, 0));
   FdInitialValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialValue);
end;

{$endif read_implementation}
