{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetOffset: TVector4;
    procedure SetOffset(const Value: TVector4);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdOffset: TSFRotation;
    { Internal wrapper for property @code(Offset). This wrapper API may change, we advise to access simpler @code(Offset) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOffset: TSFRotation read FFdOffset;
    {  }
    property Offset: TVector4 read GetOffset write SetOffset;

    strict private FEventRotation_changed: TSFRotationEvent;
    {  }
    public property EventRotation_changed: TSFRotationEvent read FEventRotation_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TSphereSensorNode ----------------------------------------------- }

function TSphereSensorNode.GetOffset: TVector4;
begin
  Result := FdOffset.Value;
end;

procedure TSphereSensorNode.SetOffset(const Value: TVector4);
begin
  FdOffset.Send(Value);
end;

class function TSphereSensorNode.ClassX3DType: String;
begin
  Result := 'SphereSensor';
end;

procedure TSphereSensorNode.CreateNode;
begin
  inherited;

  FFdOffset := TSFRotation.Create(Self, True, 'offset', Vector3(0, 1, 0), 0);
   FdOffset.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOffset);

  FEventRotation_changed := TSFRotationEvent.Create(Self, 'rotation_changed', false);
  AddEvent(FEventRotation_changed);
end;

{$endif read_implementation}
