{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdPoint: TMFVec2f;
    { Internal wrapper for property @code(Point). This wrapper API may change, we advise to access simpler @code(Point) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPoint: TMFVec2f read FFdPoint;
    {  }
    procedure SetPoint(const Value: array of TVector2); overload;
    {  }
    procedure SetPoint(const Value: TVector2List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureCoordinateNode ----------------------------------------------- }

procedure TTextureCoordinateNode.SetPoint(const Value: array of TVector2);
begin
  FdPoint.Send(Value);
end;

procedure TTextureCoordinateNode.SetPoint(const Value: TVector2List);
begin
  FdPoint.Send(Value);
end;

class function TTextureCoordinateNode.ClassX3DType: String;
begin
  Result := 'TextureCoordinate';
end;

procedure TTextureCoordinateNode.CreateNode;
begin
  inherited;

  FFdPoint := TMFVec2f.Create(Self, True, 'point', []);
   FdPoint.ChangeAlways := chTextureCoordinate;
  AddField(FFdPoint);
end;

{$endif read_implementation}
