{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetLoop: Boolean;
    procedure SetLoop(const Value: Boolean);
    function GetPauseTime: TFloatTime;
    procedure SetPauseTime(const Value: TFloatTime);
    function GetResumeTime: TFloatTime;
    procedure SetResumeTime(const Value: TFloatTime);
    function GetStartTime: TFloatTime;
    procedure SetStartTime(const Value: TFloatTime);
    function GetStopTime: TFloatTime;
    procedure SetStopTime(const Value: TFloatTime);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdLoop: TSFBool;
    { Internal wrapper for property @code(Loop). This wrapper API may change, we advise to access simpler @code(Loop) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLoop: TSFBool read FFdLoop;
    {  }
    property Loop: Boolean read GetLoop write SetLoop;

    strict private FFdPauseTime: TSFTime;
    { Internal wrapper for property @code(PauseTime). This wrapper API may change, we advise to access simpler @code(PauseTime) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPauseTime: TSFTime read FFdPauseTime;
    {  }
    property PauseTime: TFloatTime read GetPauseTime write SetPauseTime;

    strict private FFdResumeTime: TSFTime;
    { Internal wrapper for property @code(ResumeTime). This wrapper API may change, we advise to access simpler @code(ResumeTime) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdResumeTime: TSFTime read FFdResumeTime;
    {  }
    property ResumeTime: TFloatTime read GetResumeTime write SetResumeTime;

    strict private FFdStartTime: TSFTime;
    { Internal wrapper for property @code(StartTime). This wrapper API may change, we advise to access simpler @code(StartTime) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStartTime: TSFTime read FFdStartTime;
    {  }
    property StartTime: TFloatTime read GetStartTime write SetStartTime;

    strict private FFdStopTime: TSFTime;
    { Internal wrapper for property @code(StopTime). This wrapper API may change, we advise to access simpler @code(StopTime) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStopTime: TSFTime read FFdStopTime;
    {  }
    property StopTime: TFloatTime read GetStopTime write SetStopTime;

    strict private FEventElapsedTime: TSFTimeEvent;
    {  }
    public property EventElapsedTime: TSFTimeEvent read FEventElapsedTime;

    strict private FEventIsActive: TSFBoolEvent;
    {  }
    public property EventIsActive: TSFBoolEvent read FEventIsActive;

    strict private FEventIsPaused: TSFBoolEvent;
    {  }
    public property EventIsPaused: TSFBoolEvent read FEventIsPaused;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractTimeDependentNode ----------------------------------------------- }

function TAbstractTimeDependentNode.GetLoop: Boolean;
begin
  Result := FdLoop.Value;
end;

procedure TAbstractTimeDependentNode.SetLoop(const Value: Boolean);
begin
  FdLoop.Send(Value);
end;

function TAbstractTimeDependentNode.GetPauseTime: TFloatTime;
begin
  Result := FdPauseTime.Value;
end;

procedure TAbstractTimeDependentNode.SetPauseTime(const Value: TFloatTime);
begin
  FdPauseTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetResumeTime: TFloatTime;
begin
  Result := FdResumeTime.Value;
end;

procedure TAbstractTimeDependentNode.SetResumeTime(const Value: TFloatTime);
begin
  FdResumeTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetStartTime: TFloatTime;
begin
  Result := FdStartTime.Value;
end;

procedure TAbstractTimeDependentNode.SetStartTime(const Value: TFloatTime);
begin
  FdStartTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetStopTime: TFloatTime;
begin
  Result := FdStopTime.Value;
end;

procedure TAbstractTimeDependentNode.SetStopTime(const Value: TFloatTime);
begin
  FdStopTime.Send(Value);
end;

class function TAbstractTimeDependentNode.ClassX3DType: String;
begin
  Result := 'X3DTimeDependentNode';
end;

procedure TAbstractTimeDependentNode.CreateNode;
begin
  inherited;

  FFdLoop := TSFBool.Create(Self, True, 'loop', false);
   FdLoop.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLoop);

  FFdPauseTime := TSFTime.Create(Self, True, 'pauseTime', 0);
   FdPauseTime.ChangeAlways := chTimeStopStart;
  AddField(FFdPauseTime);

  FFdResumeTime := TSFTime.Create(Self, True, 'resumeTime', 0);
   FdResumeTime.ChangeAlways := chTimeStopStart;
  AddField(FFdResumeTime);

  FFdStartTime := TSFTime.Create(Self, True, 'startTime', 0);
   FdStartTime.ChangeAlways := chTimeStopStart;
  AddField(FFdStartTime);

  FFdStopTime := TSFTime.Create(Self, True, 'stopTime', 0);
   FdStopTime.ChangeAlways := chTimeStopStart;
  AddField(FFdStopTime);

  FEventElapsedTime := TSFTimeEvent.Create(Self, 'elapsedTime', false);
  AddEvent(FEventElapsedTime);

  FEventIsActive := TSFBoolEvent.Create(Self, 'isActive', false);
  AddEvent(FEventIsActive);

  FEventIsPaused := TSFBoolEvent.Create(Self, 'isPaused', false);
  AddEvent(FEventIsPaused);
end;

{$endif read_implementation}
