{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetNameField: String;
    procedure SetNameField(const Value: String);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdName: TSFString;
    { Internal wrapper for property @code(NameField). This wrapper API may change, we advise to access simpler @code(NameField) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractVertexAttributeNode ----------------------------------------------- }

function TAbstractVertexAttributeNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure TAbstractVertexAttributeNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

class function TAbstractVertexAttributeNode.ClassX3DType: String;
begin
  Result := 'X3DVertexAttributeNode';
end;

procedure TAbstractVertexAttributeNode.CreateNode;
begin
  inherited;

  FFdName := TSFString.Create(Self, False, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  DefaultContainerField := 'attrib';
end;

{$endif read_implementation}
